<?php
// config.php - Database configuration and session management
session_start();

// Database credentials
define('DB_HOST', 'localhost');
define('DB_USER', 'grounda1_admin');
define('DB_PASS', 'taQy7fr96WkYzC7');
define('DB_NAME', 'grounda1_nawiri');

// Create database connection
function getDBConnection() {
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        if ($conn->connect_error) {
            error_log("Connection failed: " . $conn->connect_error);
            die("Database connection failed. Please try again later.");
        }
        
        $conn->set_charset("utf8mb4");
        return $conn;
    } catch (Exception $e) {
        error_log("Database error: " . $e->getMessage());
        die("Database connection failed. Please try again later.");
    }
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['agent_id']) && isset($_SESSION['agent_phone']);
}

// Redirect to login if not authenticated
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit();
    }
}

// Get logged in agent phone
function getAgentPhone() {
    return $_SESSION['agent_phone'] ?? null;
}

// Get logged in agent ID
function getAgentId() {
    return $_SESSION['agent_id'] ?? null;
}

// Security: Regenerate session ID periodically
function regenerateSession() {
    if (!isset($_SESSION['last_regeneration'])) {
        $_SESSION['last_regeneration'] = time();
    } elseif (time() - $_SESSION['last_regeneration'] > 300) { // Every 5 minutes
        session_regenerate_id(true);
        $_SESSION['last_regeneration'] = time();
    }
}

// Sanitize input
function sanitizeInput($data) {
    return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
}

// Check viewport restriction (mobile only)
function checkMobileViewport() {
    // This will be handled via JavaScript in the HTML pages
    // But we can also do server-side user agent checking if needed
}

// Set security headers
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
header("Referrer-Policy: strict-origin-when-cross-origin");

// Timezone
date_default_timezone_set('Africa/Nairobi');
?>